import asyncio
from helps.logger import AppLogger
from helps.config import RootSetting
from services import webapi
from services.job_handler import JobHandler

logger = AppLogger.get_logger(__name__)


async def run(setting: RootSetting):
    logger.info("Beeble application is starting up")
    tasks = [webapi.start(setting)]
    await JobHandler.load_enabled_jobs(setting)
    process_jobs = await JobHandler.build_process_jobs(setting)
    tasks = tasks + [job.start() for job in process_jobs]
    await asyncio.gather(*tasks)
