import aiohttp
from helps.logger import AppLogger

logger = AppLogger.get_logger(__name__)


async def post_to_ollama(payload: str, rest_api: str, cb_fn):

    async with aiohttp.ClientSession() as session:
        try:
            async with session.post(
                f"http://{rest_api}",
                data=payload,
            ) as resp:
                return cb_fn(resp)
        except Exception as e:
            logger.error(e)
            raise e
