import argparse
import asyncio
import sys
import app

from helps.config import YamlConfig
from helps.logger import AppLogger

logger = AppLogger.get_logger(__name__)


async def prepare_logger(level: str):
    AppLogger.set_logger_level(level)
    AppLogger.init_logger_config()


async def prepare_config(file_path: str):
    config_fd = YamlConfig()
    try:
        return config_fd.load(file_path)
    except Exception as e:
        logger.error(e)
        return None


async def main(args: argparse.Namespace):
    level = args.log_level
    await prepare_logger(level)
    logger.info("loading config from %s" % args.config)
    settings = await prepare_config(args.config)
    if settings is None:
        logger.error("config load failed")
        sys.exit(1)
    logger.info("config loaded %s ", settings.model_dump_json(indent=4))
    await app.run(settings)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description="Beeble is for post handling the AI recogonization"
    )

    parser.add_argument(
        "--config",
        "-c",
        type=str,
        dest="config",
        default="etc/config.yaml",
        help="config file",
    )

    parser.add_argument(
        "--log-level",
        "-l",
        type=str,
        dest="log_level",
        default="info",
        help="set the log level",
    )

    args = parser.parse_args()

    asyncio.run(main(args))
