from typing import Any
from helps.config import RootSetting
from helps.logger import AppLogger
from services.jobs import BaseJob, discover_and_register_jobs, get_exec_jobs

logger = AppLogger.get_logger(__name__)

discover_and_register_jobs()


class JobHandler:

    @classmethod
    async def load_enabled_jobs(cls, settings: RootSetting):

        if not hasattr(cls, "enabled_jobs"):
            setattr(cls, "enabled_jobs", {})
        cls.enabled_jobs = {}

        for job in settings.jobs:
            job_clazz = get_exec_jobs(job.name)
            if job_clazz:
                cls.enabled_jobs[job.name] = job_clazz
                logger.info(f"load job {job_clazz.NAME}")

    @classmethod
    async def build_process_jobs(cls, settings: RootSetting) -> list[Any]:
        process_jobs: list[BaseJob] = []
        for name, clazz in cls.enabled_jobs.items():
            try:
                logger.info(f"start job {name}")
                process_jobs.append(clazz(settings))
            except Exception as e:
                logger.error(e)
        return process_jobs
