from abc import abstractmethod
import os
import importlib
from helps.config import RootSetting
from helps.logger import AppLogger
from .utils import EXEC_JOBS

logger = AppLogger.get_logger(__name__)


def discover_and_register_jobs():
    jobs_dir = os.path.dirname(__file__)
    package_name = __package__
    if not package_name:
        raise ImportError("No package name")
    for filename in os.listdir(jobs_dir):
        if filename.endswith(".py") and filename != "__init__.py":
            module_name = f"{package_name}.{filename[:-3]}"
            __import__(module_name)

            try:
                importlib.import_module(module_name)
            except ImportError as e:
                raise e


class BaseJob:

    NAME = "BaseJob"

    def __init__(self, settings: RootSetting) -> None:
        self._settings = settings

    @abstractmethod
    async def start(self): ...


def get_exec_jobs(job_name: str):
    return EXEC_JOBS.get(job_name, None)
