import os
import pathlib

from helps.config import RootSetting
from services.jobs import BaseJob
from services.jobs.utils import register_job


@register_job
class EventReporter(BaseJob):
    NAME = "event_reporter"

    def __init__(self, settings: RootSetting) -> None:
        super().__init__(settings)

    async def read_target_cache_files(self):
        all_files = os.listdir(self._settings.image_cache.target_path)
        for ifile in all_files:
            if pathlib.Path(ifile).is_file():
                yield ifile

    async def report(self, file_path): ...

    async def start(self):
        target_cache = self._settings.image_cache.target_path
        if not os.path.exists(target_cache):
            os.makedirs(target_cache)

        async for file in self.read_target_cache_files():
            file_path = pathlib.Path(self._settings.image_cache.target_path) / file
            await self.report(file_path)
